// Copyright ® 2025 OneSpan North America, Inc. All rights reserved. 

 
/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import SwiftUI

struct HeaderView: View {
    @Binding var error: Error?
    var closeButtonAction: (() -> Void)?
    
    var body: some View {
        ZStack {
            if error != nil {
                Color.red.edgesIgnoringSafeArea(.top)
            }
            
            Text(error?.localizedDescription ?? "")
                .bold()
                .multilineTextAlignment(.center)
                .foregroundColor(.white)
                .padding(.vertical, 16)
                .padding(.horizontal, 76)
                .frame(maxWidth: .infinity)
            
            HStack {
                Spacer()
                
                Button(action: {
                    closeButtonAction?()
                }) {
                    Image("close_x")
                        .resizable()
                        .frame(width: 55, height: 55)
                        .foregroundColor(.white)
                        .padding()
                }
            }
        }
        .frame(maxWidth: .infinity, alignment: .top)
        .frame(height: 70)
    }
}
